<?php
/**
 * ----------------------------------------------------
 * Session Handler - Aplikasi Koperasi
 * ----------------------------------------------------
 */

// Jangan start session dua kali
if (session_status() === PHP_SESSION_NONE) {

    // Konfigurasi cookie session
    $cookieParams = session_get_cookie_params();

    session_set_cookie_params([
        'lifetime' => 0,
        'path'     => $cookieParams['path'],
        'domain'   => $cookieParams['domain'],
        'secure'   => false, // ubah true jika HTTPS
        'httponly' => true,
        'samesite' => 'Strict'
    ]);

    session_start();
}

// Regenerasi session ID setelah login
function regenerate_session()
{
    session_regenerate_id(true);
}

// Cek apakah user sudah login
function is_logged_in()
{
    return isset($_SESSION['user_id']);
}

// Hapus semua session
function destroy_session()
{
    $_SESSION = [];
    session_destroy();
}
